#include<stdio.h> 

#include<stdlib.h>

#include<string.h>

#include<math.h> 

#define PI 3.141592653589793238462643



/* compiling with DJGPP: gcc -o eh eh.c -lm */



/********************************************************************

* Program to determine the different speeds the rotator and azimuth *

* could reach in an Alt-Az telescope.                               *

********************************************************************/







/* Degrees - Radians converter: from degrees to radians */



double radian(double degrees) {

   

   return(degrees*PI/180);



}







/* Radians - Degrees converter: from radians to degrees */



double degree(double radians) {

   

   return(radians*180/PI);



}







/* The parallactic angle equation given by latitud, declination and hour angle */



double parallang(double lat, double decl, double HA) {



   double p=0;

   double rp=0;

   double rlat=radian(lat);

   double rdecl=radian(decl);

   double rHA=radian(HA);



   rp=atan(sin(rHA)/(cos(rdecl)*tan(rlat)-sin(rdecl)*cos(rHA)));

   p=degree(rp);

   return(p);



}







double Azimuth(double lat, double decl, double HA) {



   double A=0;

   double rA=0;

   double rlat=radian(lat);

   double rdecl=radian(decl);

   double rHA=radian(HA);



   rA=atan(sin(rHA)/(sin(rlat)*cos(rHA)-cos(rlat)*tan(rdecl)));

   A=degree(rA);

   return(A);



}







/* The rotator speed equation given by latitud, declination and hour angle, first method */



double rotspeed1(double lat, double decl, double HA) {



   double speed=0;

   double rspeed=0;

   double rlat=radian(lat);

   double rdecl=radian(decl);

   double rHA=radian(HA);

   double rsidrate=0.25*PI/90;   /* sidereal rate of H increment in radians: 0.25 in 1 minute */

   double n=cos(rdecl)*sin(rlat)-sin(rdecl)*cos(rHA);   /* temporal variable */



   rspeed=(n*cos(rHA)-pow(sin(rHA),2)*sin(rdecl))/(pow(n,2)+pow(sin(rHA),2))*rsidrate;

   speed=degree(rspeed);

   return(speed);



}







/* The azimuth speed equation given by latitud, declination and hour angle , first method */



double azspeed1(double lat, double decl, double HA) {



   double speed=0;

   double rspeed=0;

   double rlat=radian(lat);

   double rdecl=radian(decl);

   double rHA=radian(HA);

   double rsidrate=0.25*PI/90;   /* sidereal rate of H increment in radians: 0.25 in 1 minute */

   double rz=acos(sin(rlat)*sin(rdecl)+cos(rlat)*cos(rdecl)*cos(rHA));   /* zenith distance in radians */

   double rA=asin(sin(rHA)*cos(rdecl)/sin(rz));   /* Azimuth in radians */



   rspeed=((1/tan(rz))*cos(rA)*cos(rlat)-sin(rlat))*rsidrate;

   speed=degree(rspeed);

   return(speed);



}







/* The rotator speed equation given by latitud, declination and hour angle, second method */



double rotspeed2(double lat, double decl, double HA) {



   double speed=0;

   double rspeed=0;

   double rlat=radian(lat);

   double rdecl=radian(decl);

   double rHA=radian(HA);

   double rz=acos(sin(rlat)*sin(rdecl)+cos(rlat)*cos(rdecl)*cos(rHA));   /* zenith distance in radians */

   double rA=atan(sin(rHA)/(sin(rlat)*cos(rHA)-cos(rlat)*tan(rdecl)));   /* Azimuth in radians */



   rspeed=(0.25*PI/90)*cos(rlat)*cos(rA)/sin(rz);

   speed=degree(rspeed);

   return(speed);



}







/* The azimuth speed equation given by latitud, declination and hour angle , second method */



double azspeed2(double lat, double decl, double HA) {



   double speed=0;

   double rspeed=0;

   double rlat=radian(lat);

   double rdecl=radian(decl);

   double rHA=radian(HA);

   double rz=acos(sin(rlat)*sin(rdecl)+cos(rlat)*cos(rdecl)*cos(rHA));   /* zenith distance in radians */

  

   rspeed=(0.25*PI/90)*(sin(rlat)-sin(rdecl)*cos(rz))/pow(sin(rz),2);

   speed=degree(rspeed);

   return(speed);



}





int main(){

   double phi=0;      /* Latitude        */

   double delta=0;    /* Declination     */

   double HA=0;       /* Hour angle      */

   double dparang=0;  /* Differential parallactic angle */

   double dAzimuth=0; /* Differential azimuth */

   double h=0.0000000000001;   /* Limit to zero */



   phi=-29.25;    /* Latitud of La Silla in degrees: -2915 */

   

   printf("\n\nBienvenido, Welcome, Bienvenue, Willkommen, Benvenuto, Boa vinda\n\n");

   printf("\nHA\t\trs1\t\tazs1\t\trs2\t\tazs2\t\tdecl\t\trs3\t\tazs3\n");

   

   for(delta=58.8 ; delta<=60.5 ; delta=delta+0.1) {



      for(HA=-60 ; HA<=60 ; HA=HA+0.1) {         

	 

	 dparang=(parallang(phi,delta,HA+h)-parallang(phi,delta,HA))/h;

         dAzimuth=(Azimuth(phi,delta,HA+h)-Azimuth(phi,delta,HA))/h;



         printf("%lf\t%lf\t%lf\t%lf\t%lf\t%lf\t%lf\t%lf\n", HA/60, rotspeed1(phi,delta,HA), azspeed1(phi,delta,HA), rotspeed2(phi,delta,HA), azspeed2(phi,delta,HA), delta, dparang/3, dAzimuth/3);

      }

      

      printf("\n\n ************************************** \n\n");   

   

   }







  return(EXIT_SUCCESS);



}        

        



